/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.dao.vo;

import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.vo.AbstractCapabilityVO;
import com.quantumdata.sct.dao.vo.ParameterVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;

public class ModelCapabilityVO
implements IPersistable,
Comparable {
    private boolean isNew;
    private boolean isDirty;
    private String modelId;
    private long lastUpdate;
    private LinkedHashMap capabilities;

    public ModelCapabilityVO() {
        this.isNew = false;
        this.isDirty = false;
        this.modelId = null;
        this.capabilities = new LinkedHashMap();
    }

    public ModelCapabilityVO(ModelCapabilityVO modelCapabilityVO) {
        this.copy(modelCapabilityVO);
    }

    protected void copy(ModelCapabilityVO modelCapabilityVO) {
        this.isNew = modelCapabilityVO.isNew;
        this.isDirty = modelCapabilityVO.isDirty;
        this.modelId = modelCapabilityVO.modelId;
        this.lastUpdate = modelCapabilityVO.lastUpdate;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew() {
        this.isNew = true;
    }

    public void setNew(boolean bl) {
        this.isNew = bl;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty() {
        this.isDirty = true;
    }

    public void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    public Object getId() {
        return this.modelId;
    }

    public void setId(Object object) {
        this.modelId = (String)object;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String string) {
        this.modelId = string;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(long l) {
        this.lastUpdate = l;
    }

    public void setModelCapabilityElementVO(ModelCapabilityElementVO modelCapabilityElementVO) {
        this.capabilities.put(modelCapabilityElementVO.getCapabilityId(), modelCapabilityElementVO);
    }

    public ModelCapabilityElementVO getElement(String string) {
        return (ModelCapabilityElementVO)this.capabilities.get(string);
    }

    public boolean isCapabilitySupported(String string) {
        ModelCapabilityElementVO modelCapabilityElementVO;
        return this.capabilities.containsKey(string) && (modelCapabilityElementVO = (ModelCapabilityElementVO)this.capabilities.get(string)).isSupported;
    }

    public boolean isCapabilityExists(String string) {
        return this.capabilities.containsKey(string);
    }

    public AbstractCapabilityVO[] getSupportedCapabilities() throws Exception {
        ArrayList<AbstractCapabilityVO> arrayList = new ArrayList<AbstractCapabilityVO>();
        for (ModelCapabilityElementVO modelCapabilityElementVO : this.capabilities.values()) {
            if (!modelCapabilityElementVO.isSupported()) continue;
            arrayList.add(modelCapabilityElementVO.getCapability());
        }
        return (AbstractCapabilityVO[])arrayList.toArray();
    }

    public void setAllCapabilities(ModelCapabilityElementVO[] modelCapabilityElementVOArray) {
        this.capabilities.clear();
        int n = modelCapabilityElementVOArray.length;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.capabilities.put(modelCapabilityElementVOArray[i].getCapabilityId(), modelCapabilityElementVOArray[i]);
            }
        }
    }

    public ModelCapabilityElementVO[] getAllCapabilities() {
        return (ModelCapabilityElementVO[])this.capabilities.values().toArray();
    }

    public Collection getCapabilities() {
        return this.capabilities.values();
    }

    public void setCapabilities(Collection collection) throws ClassCastException {
        this.capabilities.clear();
        for (ModelCapabilityElementVO modelCapabilityElementVO : collection) {
            this.capabilities.put(modelCapabilityElementVO.getCapabilityId(), modelCapabilityElementVO);
        }
    }

    public int compareTo(Object object) throws ClassCastException {
        return this.modelId.compareTo(((ModelCapabilityVO)object).modelId);
    }

    public static class ModelCapabilityElementVO
    extends ParameterVO
    implements Comparable {
        private String capabilityId = null;
        private boolean isSupported = false;

        public void setCapability(AbstractCapabilityVO abstractCapabilityVO) {
            this.capabilityId = (String)abstractCapabilityVO.getId();
        }

        public AbstractCapabilityVO getCapability() throws Exception {
            return (AbstractCapabilityVO)((Object)XMLDAOFactory.getCapabilityDAO().read(this.capabilityId));
        }

        public String getCapabilityId() {
            return this.capabilityId;
        }

        public void setCapabilityId(String string) {
            this.capabilityId = string;
        }

        public boolean isSupported() {
            return this.isSupported;
        }

        public void setSupported(boolean bl) {
            this.isSupported = bl;
        }

        public int compareTo(Object object) throws ClassCastException {
            return this.capabilityId.compareTo(((ModelCapabilityElementVO)object).capabilityId);
        }
    }
}

